--STORED PROCEDURE FOR CREATING USERS FOR THE APPLICATION

---This procedure is created for creating the users for Genisis2.0. This procedure would insert the values into Users, User_Role_Type and User_Approver. Following is the script for creating it.

USE [GENISIS_DB]
GO

/****** Object:  StoredProcedure [dbo].[Usp_Insert_Usermgt]   ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROC [dbo].[Usp_Insert_Usermgt]

(@User_id VARCHAR(320), 
@First_Name VARCHAR(50), 
@Middle_Name VARCHAR(50), 
@Last_Name VARCHAR(50), 
@user_approver_id varchar(320), 
@Role_Type_id int, 
@User_Type_id int
)
 as

SET NOCOUNT ON
SET XACT_ABORT ON

 BEGIN
BEGIN TRANSACTION
BEGIN TRY

        insert into dbo.Users
        (User_id,First_Name,Middle_Name,Last_Name,Create_Date,Email_id,User_Active,Active_date,Inactive_date) 
        values 
        (@User_id,@First_Name,@Middle_Name,@Last_Name,GETDATE(),@User_id,1,GETDATE(),null)


		DECLARE @id int
		SET @Id = (Select max(Id) from User_Role_Type)+1
             
   
INSERT [dbo].[User_Role_Type] ([Id], [Role_Type_id], [User_Type_id], [User_id], [Start_Date], [End_Date]) VALUES
 (@Id,@Role_Type_id,@User_Type_id,@User_id,GETDATE(),null)
    

	DECLARE @NEW_ID int
	SET @NEW_ID = (Select max(Id) from User_Approver)+1

  INSERT [dbo].[User_Approver] ([Id], [User_id], [User_Approver_id])
  VALUES(@NEW_ID,@User_id,@user_approver_id)

  COMMIT;

  SELECT 'USER CREATED SUCCESSFULLY' AS MESSAGE

 END TRY

BEGIN CATCH
			ROLLBACK;
			SELECT 'User not Created' AS MESSAGE
END CATCH

END
GO
